#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Alien ToothpasteMod01.fsh  by   isaacchurchill  
//https://www.shadertoy.com/view/7lcyR4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177 //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float PI = 3.14159265;

vec3 palette(float f)
{
    return vec3(
        sin(f), sin(f + 2.0), sin(f + 4.0)
    ) * 0.5 + 0.5;
}

vec3 palette2(float f)
{
    return vec3(
        sin(f), sin(f + 1.0), sin(f + 2.0)
    ) * 0.5 + 0.5;
}

float checker(vec2 uv)
{
    return abs(
        (mod(uv.x, 1.0) > 0.5 ? 1.0 : 0.0)
        - (mod(uv.y, 1.0) > 0.5 ? 1.0 : 0.0));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 pos = fragCoord / iResolution.xy;
    pos -= 0.5;
    pos *= 2.0;
    pos.x *= iResolution.x / iResolution.y;
    
    float ceil_y = cos((pos.x + iTime) * 4.0 * PI + PI) * -0.05 + 0.72;
    float top_y = abs(mod((pos.x + iTime) * 4.0, 2.0) - 1.0) * 0.3 + 0.5;
    float mid_y = sin((pos.x - iTime * 1.0) * PI * 2.0) * 0.3;
    float bot_y = sin((pos.x + iTime * 0.15) * PI * 2.0) * 0.2 - 0.7;
    
    vec3 col = vec3(0.0);
    col += vec3(1.0, 0.4, 0.0) / (1.0 + 30.0 * abs(top_y - pos.y));
    col += vec3(1.0, 0.2, 0.4) / (1.0 + 30.0 * abs(mid_y - pos.y));
    col += vec3(1.0, 0.0, 0.0) / (1.0 + 20.0 * abs(bot_y - pos.y));
    
    if (pos.y < ceil_y && pos.y > top_y) {
        col = pow(col, vec3(0.5));
    } else if (pos.y < top_y && pos.y > mid_y) {
        col += palette(((pos.y - mid_y) / (top_y - mid_y)) * 10.0);
    } else if (pos.y < mid_y && pos.y > bot_y) {
        col += palette2(((pos.y - bot_y) / (mid_y - bot_y)) * 10.0);
    } else if (pos.y < bot_y) {
        col += checker(pos * 4.0) * (bot_y - pos.y);
    }
    
    vec3 circle1_col = vec3(1.0, 1.0, 1.0);
    vec3 circle2_col = vec3(1.0, 0.0, 0.0);
    float inner_swelling = sin(iTime * PI) + 1.5;
    float circle_de = length(vec2(mod((pos.x - 0.25 + iTime) + 0.5, 1.0) - 0.5, pos.y - 0.83));
    float first_circle_de = abs(circle_de - 0.1);
    float second_circle_de = abs(circle_de - 0.03 * inner_swelling);
    col += circle1_col * clamp(pow(1.0 / (first_circle_de * 100.0 + 0.5), 2.0), 0.0, 1.0);
    col += circle2_col * clamp(pow(1.0 / (second_circle_de * 100.0 + 0.5), 2.0), 0.0, 1.0);
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

